<?php

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    //
    // Create a widget 1
    //
    CSF::createWidget( 'csf_widget_slider_image', array(
      'title'       => 'اسلایدر تصاویر',
      'classname'   => 'csf-widget-classname',
      'description' => ' اسلایدر تصاویر banikala',
      'fields'      => array(

        array(
            'id'        => 'list_slider',
            'type'      => 'group',
            'title'     => 'اسلایدر تصاویر',
            'fields'    => array(
                array(
                    'id'    => 'title',
                    'type'  => 'text',
                    'title' => 'عنوان اسلایدر',
                    'default' => 'اسلایدر 1',
                  ),
                array(
                    'id'      => 'list_image',
                    'type'    => 'media',
                    'title'   => 'بارگذاری تصویر',
                    'preview' => true,
                ),
              array(
                'id'    => 'list_link',
                'type'  => 'text',
                'title' => 'لینک اسلایدر',
              ),

            ),
          ),

                       // A Heading
                       array(
                        'type'    => 'heading',
                        'content' => 'پیکربندی اسلایدر',
                    ),
                    array(
                        'id'          => 'slider-spacing-margin-slider-image',
                        'type'        => 'spacing',
                        'title'       => 'فاصله خارجی',
                        'default'     => array(
                          'top'       => '20',
                          'right'     => '0',
                          'bottom'    => '20',
                          'left'      => '0',
                          'unit'      => 'px',
                        ),
                       ),
                       array(
                        'id'    => 'amazing-border-raduis-slider',
                        'type'  => 'number',
                        'title' => 'انحنای مرز',
                       ),
                    array(
                        'id'    => 'loop',
                        'type'  => 'switcher',
                        'title' => 'نمایش بی نهایت',
                        'default' => 'true',
                    ),
                    array(
                        'id'    => 'nav',
                        'type'  => 'switcher',
                        'title' => 'پیکان ها',
                        'default' => 'true',
                    ),
                    array(
                        'id'    => 'nav_style',
                        'type'  => 'Select',
                        'title' => __( 'مدل پیکان', 'parskala' ),
                        'default' => 'Square',
                        'options' => [
                            'circle' => 'دایره',
                            'Square' => 'مربعی',
                        ],
                    ),
                    array(
                        'id'    => 'dots',
                        'type'  => 'switcher',
                        'title' => esc_html__( 'نمایش نقطه ها', 'plugin-name' ),
                        'default' => 'true',
                    ),
                    array(
                        'id'    => 'dots_style',
                        'type'  => 'select',
                        'title' => esc_html__( 'طرح نقطه ها', 'plugin-name' ),
                        'default' => 'default',
                        'options' => [
                            'default' => 'پیشفرض',
                            'style1' => 'سبک 1',
                            'style2' => 'سبک 2',
                            'style3' => 'سبک 3',
                        ],
                    ),
        
                    array(
                        'id'    => 'autoplay',
                        'type'  => 'switcher',
                        'title' => 'نمایش خودکار',
                        'default' => 'false',
                    ),
        
                    array(
                        'id'    => 'delay',
                        'type'  => 'number',
                        'title' => esc_html__( 'سرعت پخش', 'plugin-name' ),
                        'default' => '3000',
                    ),
                    array(
                      'id'    => 'full_width_slider',
                      'type'  => 'switcher',
                      'title' => esc_html__( 'تمام عرض', 'plugin-name' ),
                      'default' => 'false',
                    ),
                    array(
                      'id'    => 'show_just_desctop',
                      'type'  => 'switcher',
                      'title' => esc_html__( 'نمایش فقط برای دسکتاپ', 'plugin-name' ),
                      'subtitle' => esc_html__( ' اگر این گزینه فعال شود اسلایدر تنها در دسکتاپ نمایش داده میشود ، در غیراز این صورت فقط در دیوایس موبایل و تبلت نمایش داده میشود. ', 'plugin-name' ),
                      'default' => 'false',
                    ),

      )

    ) );
  
    //
    // Front-end display of widget example 1
    // Attention: This function named considering above widget base id.
    //

    if( ! function_exists( 'csf_widget_slider_image' )  ) {

    function array_classes_implode_slider($classes,$property){
      $classes_implode='';
      $unit= $classes['unit'];
      unset($classes['unit']);
      foreach($classes as $class_key => $class_value){
        $classes_implode .= $property.'-'.$class_key.':'.$class_value.$unit.';';
      }
      return $classes_implode;
    }
  
    function csf_widget_slider_image( $args, $settings ) {
    
      if ( $settings['show_just_desctop'] == '0' ){
        if ( mobile_cheker() || tablet_cheker() ){
          
        }else{
          return false;
        }
      }elseif( $settings['show_just_desctop'] == '1' ){
        if ( !mobile_cheker() && !tablet_cheker() ){
          
        }else{
          return false;
        }
      }

  $border_radius = $settings['amazing-border-raduis-slider'] ? 'border-radius:'. $settings['amazing-border-raduis-slider'].'px;' : '';
   $have_contier = $settings['full_width_slider'] == '0' ? 'continer ' : '';

    $settings_slider =  array(
		'loop' => $settings['loop']  ? 'true' : 'false',
		'nav' => $settings['nav']  ? 'true' : 'false',
		'dots' => $settings['dots']  ? 'true' : 'false',
	    'autoplay' => $settings['autoplay']  ? 'true' : 'false',
		'delay' => $settings['delay'] ? $settings['delay'] : '3000',
	    );
	    $json_settings = json_encode($settings_slider);



		if ( $settings['list_slider'] ):?>

        <div class="<?= $have_contier ?>main-slider-box">


        <div class="slider-right ver1 <?=  $settings['dots_style'] ?>" style="<?= array_classes_implode_slider($settings['slider-spacing-margin-slider-image'],'margin') . $border_radius ?> ">



                <div class="slide-carousel <?= $settings['nav_style'] == 'Square' ? 'nav_Square' : ''; ?>" settings-slider='<?php echo $json_settings;?>'>
        
                <?php
                            foreach (  $settings['list_slider'] as $item ):

                                        ?>

                    <div class="slide-pre">

                                        <a href="<?php echo $item['list_link'];?>">
                                            <img src="<?= $item['list_image']['url'] ?>" alt="image-slider">
                                    </a>

                    </div>


                <?php endforeach;?>



            </div>

        </div>

        <?php if ( $settings['dots_style'] == 'style2' ):?>

            <div class="victor-style2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="231" height="75" viewBox="0 0 231 75" fill="none">
                        <path clip-rule="evenodd" d="M0 0C31.5006 0.949537 50.52 17.872 56.1955 26.4544L55.986 25.8011L82.4924 58.631C99.3032 79.4521 131.038 79.4521 147.849 58.6309L174.356 25.8011L174.146 26.4544C179.822 17.872 198.844 0.949537 230.349 0H0Z"></path>
                    </svg>
            </div>

            <?php endif; ?>

            <?php if ( $settings['dots_style'] == 'style3' ):?>

                <div class="victor-style3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="167" height="48" viewBox="0 0 167 48" fill="none"><path d="M9.45585 0C4.50967 0 0.5 4.00967 0.5 8.95585C0.5 13.0893 3.3288 16.6858 7.34586 17.6596L10.289 18.3731C14.4779 19.3886 17.875 22.4432 19.3282 26.5011L23.4667 38.0573C25.6024 44.0208 31.254 48 37.5885 48L132.494 48C138.942 48 144.668 43.8795 146.717 37.7659L149.9 28.268C151.236 24.2785 154.205 21.0445 158.066 19.3716L161.363 17.9425C164.785 16.4597 167 13.0864 167 9.35697C167 4.18926 162.811 0 157.643 0L9.45585 0Z" fill="white"></path></svg>
                </div>

            <?php endif; ?>

            </div>




		<?php endif;?>

    <?php


      }
    }
  
  }