<?php
// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    //
    // Create a widget 1
    //
 
    CSF::createWidget( 'csf_widget_item', array(
      
      'title'       => 'آیتم ها',
      'classname'   => 'csf-widget-classname',
      'description' => 'آیتم ها banikala',
      'fields'      => array(

 

        array(
            'id'      => 'title_section',
            'type'    => 'text',
            'title'   => __( 'عنوان سکشن', 'prk' ),
            'default' => 'دسته بندی های ویژه'
        ),
        array(
          'id'      => 'title_icon',
          'type'    => 'text',
          'title'   => 'ایکن',
        ),

          array(
            'id'    => 'amazing-border-raduis',
            'type'  => 'number',
            'title' => 'انحنای مرز',
          ),

          array(
            'id'        => 'list_item',
            'type'      => 'group',
            'title'     => 'آیتم ها',
            'fields'    => array(
                array(
                    'id'    => 'title',
                    'type'  => 'text',
                    'title' => 'عنوان آیتم',
                    'default' => 'اسلایدر 1',
                  ),
                  array(
                    'id'    => 'list_title_shows',
                    'type'  => 'switcher',
                    'title' => 'نمایش عنوان',
                  ),
                  array(
                      'id'      => 'list_image',
                      'type'    => 'media',
                      'title'   => 'بارگذاری تصویر',
                      'preview' => true,
                  ),
                  array(
                    'id'    => 'list_link',
                    'type'  => 'text',
                    'title' => 'لینک اسلایدر',
                  ),

            ),
          ),

                  // slider settings
        array(
          'type'    => 'heading',
          'content' => 'پیکربندی اسلایدر آیتم',
        ),
  
        array(
          'id'         => 'loop', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش بینهایت',
          'default'    => true,
        ),
        array(
          'id'         => 'nav', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش پیکان ها',
          'default'    => true,
        ),
        array(
          'id'         => 'dots', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش نقطه ها',
          'default'    => true,
        ),
        array(
          'id'         => 'autoplay', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش خودکار',
          'default'    => true,
        ),
        array(
          'id'         => 'delay', // field id
          'type'       => 'number',
          'title'      => 'سرعت (میلی ثانیه)',
          'default'    => '3000',
        ),
        array(
          'id'    => 'item',
          'type'  => 'slider',
          'title' => 'تعداد آیتم',
          'min'     => 1,
          'max'     => 7,
          'step'    => 1,
          'default' => 5,
        ),
  

      )

    ) );
  
    //
    // Front-end display of widget example 1
    // Attention: This function named considering above widget base id.
    //

    function array_classes_implode_item($classes,$property){
        $classes_implode='';
        $unit= $classes['unit'];
        unset($classes['unit']);
        foreach($classes as $class_key => $class_value){
          $classes_implode .= $property.'-'.$class_key.':'.$class_value.$unit.';';
        }
        return $classes_implode;
    }

    if( ! function_exists( 'csf_widget_item' ) ) {

      function csf_widget_item( $args, $settings ) {

        $class_dev = 'item-brands';
       
        $hide_head = '1';
  
  

        if ($hide_head == '1') {
          $classes = 'nogeneral';
        }else {
          $classes = '';
        }

        $settings_slider =  array(
          'item'     => $settings['item'] ? $settings['item'] : '4',
          'loop'     => $settings['loop'] == '1' ? 'true' : 'false',
          'nav'      => $settings['nav'] == '1' ? 'true' : 'false',
          'autoplay' => $settings['autoplay'] == '1' ? 'true' : 'false',
          'delay'    => $settings['delay'],
          'dots'     => $settings['dots'] == '1' ? 'true' : 'false',
          'margins'  => '5',
        );
       
        $json_settings = json_encode($settings_slider);

        if (mobile_cheker() || tablet_cheker()) {
          $class_section = 'carousel_lister';
        }else {
          $class_section = 'banikala-items';
        }
        
        ?>
    
        <?php if ( $settings['list_item'] ):?>
    
          <section class="item-image-box continer">
             
          <h3 class="header-title"><?= $settings['title_section']  ?></h3>
           
          <div class="<?= $class_section ?>">
            <?php
            foreach ($settings['list_item']  as $item) {

              echo '<div class="item-image"><a href=" '.$item['list_link'].' ">';
               echo '<img src=" '.$item['list_image']['url'].' " alt="">';
              echo '</a></div>';
            } 
            ?>
          </div>
          </section>
    
        <?php endif;?>
    
        <?php

      }
    }
  
  }