<?php
// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    //
    // Create a widget 1
    //
 
    CSF::createWidget( 'csf_widget_item_slider', array(
      
      'title'       => 'اسلایدر آیتم ها',
      'classname'   => 'csf-widget-classname',
      'description' => 'اسلایدر آیتم ها banikala',
      'fields'      => array(

 

        array(
            'id'      => 'title_section',
            'type'    => 'text',
            'title'   => __( 'عنوان سکشن', 'prk' ),
            'default' => 'دسته بندی های ویژه'
        ),
        array(
          'id'      => 'title_icon',
          'type'    => 'text',
          'title'   => 'ایکن',
        ),

          array(
            'id'    => 'amazing-border-raduis',
            'type'  => 'number',
            'title' => 'انحنای مرز',
          ),

          array(
            'id'        => 'list_item_slider',
            'type'      => 'group',
            'title'     => 'اسلایدر آیتم ها',
            'fields'    => array(
                array(
                    'id'    => 'title',
                    'type'  => 'text',
                    'title' => 'عنوان اسلایدر',
                    'title' => 'آیتم 1',
                  ),
                  array(
                    'id'    => 'list_title_shows',
                    'type'  => 'switcher',
                    'title' => 'نمایش عنوان',
                  ),
                  array(
                      'id'      => 'list_image',
                      'type'    => 'media',
                      'title'   => 'بارگذاری تصویر',
                      'preview' => true,
                  ),
                  array(
                    'id'    => 'list_link',
                    'type'  => 'text',
                    'title' => 'لینک اسلایدر',
                  ),
                  array(
                    'id'    => 'item-background',
                    'type'  => 'color',
                    'title' => 'رنگ پس زمینه آیتم',
                    // 'output' => array( 'background-color' => '.widget-slider-section.slider-default')
                  ),

            ),
          ),

                  // slider settings
        array(
          'type'    => 'heading',
          'content' => 'پیکربندی اسلایدر آیتم',
        ),
  
        array(
          'id'         => 'loop', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش بینهایت',
          'default'    => true,
        ),
        array(
          'id'         => 'nav', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش پیکان ها',
          'default'    => true,
        ),

        array(
          'id'         => 'autoplay', // field id
          'type'       => 'switcher',
          'title'      => 'نمایش خودکار',
          'default'    => true,
        ),
        array(
          'id'         => 'delay', // field id
          'type'       => 'number',
          'title'      => 'سرعت (میلی ثانیه)',
          'default'    => '3000',
        ),
        array(
          'id'    => 'item',
          'type'  => 'slider',
          'title' => 'تعداد آیتم',
          'min'     => 1,
          'max'     => 7,
          'step'    => 1,
          'default' => 5,
        ),
  

      )

    ) );
  
    //
    // Front-end display of widget example 1
    // Attention: This function named considering above widget base id.
    //

    function array_classes_implode_item_slider($classes,$property){
        $classes_implode='';
        $unit= $classes['unit'];
        unset($classes['unit']);
        foreach($classes as $class_key => $class_value){
          $classes_implode .= $property.'-'.$class_key.':'.$class_value.$unit.';';
        }
        return $classes_implode;
    }

    if( ! function_exists( 'csf_widget_item_slider' ) ) {

      function csf_widget_item_slider( $args, $settings ) {

        $class_dev = 'item-brands';
        
        $hide_head = '1';
  
  

        if ($hide_head == '1') {
          $classes = 'nogeneral';
        }else {
          $classes = '';
        }

        $settings_slider =  array(
          'item'     => $settings['item'] ? $settings['item'] : '4',
          'loop'     => $settings['loop'] == '1' ? 'true' : 'false',
          'nav'      => $settings['nav'] == '1' ? 'true' : 'false',
          'autoplay' => $settings['autoplay'] == '1' ? 'true' : 'false',
          'delay'    => $settings['delay'],

          'margins'  => '5',
        );
       
        $json_settings = json_encode($settings_slider);


        
        ?>
    
        <?php if ( $settings['list_item_slider'] ):?>
    
          <section class="item-image-box slider-item continer">

          <?php if ( !empty($settings['title_section']) ) :?>

            <h3 class="header-title"><?= $settings['title_section'] ?></h3>

          <?php endif;?>

          <div class="swiper widget-item-slider" item-settings-slider='<?php echo $json_settings; ?>'>
            <div class="swiper-wrapper">
              <?php
              
              foreach ($settings['list_item_slider'] as  $key => $item) {
                $background = $item['item-background'] ? 'background:'. $item['item-background'] : '';
                $Random_class = slider_notnuberRandomString();
                if ( !empty($item['item-background']) ){
                ?>
                <style>
                  section.item-image-box .widget-item-slider .item-image.<?= $Random_class ?> a::before{
                   background: <?= $item['item-background'] ?> !important;
                  }
                </style>
                <?php
                }
                echo '<div class="item-image swiper-slide '.$Random_class.'"><a href=" '.$item['list_link'].' ">';
                echo '<img src=" '.$item['list_image']['url'].' " alt="">';
                echo '</a>';
                echo '<span class="item-image-title">'.$item['title'].'</span>';
                echo '</div>';
              } 
              ?>
            </div>
          </div>
          </section>
    
        <?php endif;?>
    
        <?php

      }
    }
  
  }