<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme ahura
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */


require_once get_template_directory() . '/inc/wizard/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'prk_required_plugins' );

function prk_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(


		array(
			'name'      => __('WooCommerce', 'parskala'),
			'slug'      => 'woocommerce',
			'required'  => true,
		),
		array(
			'name'      => __('Elementor Page Builder', 'parskala'),
			'slug'      => 'elementor',
			'required'  => true,
		),
		array(
			'name'      => __('Persian Woocommerce', 'parskala'),
			'slug'      => 'persian-woocommerce',
			'required'  => true,
		),
		array(
			'name'      => __('advanced free shipping', 'parskala'),
			'slug'      => 'woocommerce-advanced-free-shipping',
			'required'  => false,
		),

	);

	$config = array(
		'id'           => 'parskala',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'prk-install-plugins', // Menu slug.
		'parent_slug'  => 'prk-theme',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => 'چشم پوشی',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'strings'      => array(
			'page_title'                      => __( 'نصب افزونه های واجب پارس کالا', 'theme-slug' ),
			'menu_title'                      => __( 'نصب افزونه ها', 'theme-slug' ),
		),
	);

	tgmpa( $plugins, $config );
}
