<?php
/**
 * Class for the Redux importer.
 *
 * @see https://wordpress.org/plugins/redux-framework/
 *
 * @package Merlin WP
 */

class Merlin_Redux_Importer {
	/**
	 * Import Redux data from a JSON file, generated by the Redux plugin.
	 *
	 * @param array $import_data Array of arrays. Child array contains 'option_name' and 'file_path'.
	 *
	 * @return boolean
	 */
	public static function import( $import_data ) {
		// Redux plugin is not active!
		// if ( ! class_exists( 'ReduxFramework' ) || ! class_exists( 'ReduxFrameworkInstances' ) || empty( $import_data ) ) {
		// 	return false;
		// }
		if ( empty( $import_data ) ) {
			return false;
		}
	
		foreach ( $import_data as $codestar_item ) {
			$codestar_opt_raw_data = file_get_contents($codestar_item['file_path']);
			$codestar_opt_data     = json_decode($codestar_opt_raw_data,true);
			$codestar_opt_name        = 'prk_option';

		
			
                
				update_option( $codestar_opt_name, $codestar_opt_data );
			
			
		}
		

		return true;
	}
}
